// brain bot preview space
// m.miller 07.14.23

#version 3.8; 
global_settings {  
    max_trace_level 7
    ambient_light <.013,.01,.01> * 1 
    assumed_gamma 1                
}                        

#include "default_materials.inc"
#declare lights_on = 1;
#declare light_butt_on = 1;
// -----------------------------------------------------------------------------------------
//                    B R A I N    B O T
//------------------------------------------------------------------------------------------ 
#include "brain_bot.inc"  
#include "shapes.inc"
#include "shapes2.inc"
object { brain_bot scale <1.25,1.2,1.4> rotate <30,0,0> translate <0,-15,0>}
//object { brain_bot rotate <15,-40,0> translate <40,10,-20>}


// -----------------------------------------------------------------------------------------
//                    I - B E A M 
//------------------------------------------------------------------------------------------ 
#include "macro_beam.inc"
//object { i_beam() scale <.5,.5,.5> rotate <0,0,0> rotate <0,-30,0> translate <0,-55,-70>}
//object { i_beam() scale <.5,.5,.5> rotate <-20,0,0> rotate <0,60,0> translate <10,-50,200>}



// -----------------------------------------------------------------------------------------
//                    R A Y   B E A M   T O W E R S 
//------------------------------------------------------------------------------------------ 
#include "ray_beam_tower.inc"
object { ray_beam_tower scale <2,2,2> translate <-200,-1700,3000>  }
object { ray_beam_tower scale <5,5,5> translate <-360,-2400,2200>  }
object { ray_beam_tower scale <2.2,2.2,2.2> translate <400,-1200,1500>  }
object { ray_beam_tower scale <3,3,3> translate <1380,-2700,4500>  }
object { ray_beam_tower scale <3,3,3> translate <580,-3100,4500>  }


// -----------------------------------------------------------------------------------------
//                    R A Y   B E A M   T O W E R S 
//------------------------------------------------------------------------------------------ 
#include "masthead.inc"  
object { masthead scale <1.2,1,1> rotate <-70,0,0> rotate <0,20,1> translate <-1,70,0> }
//object { masthead rotate <00,0,0> rotate <0,00,0> translate <0,0,0> }


// -----------------------------------------------------------------------------------------
//                     L I G H T S 
//------------------------------------------------------------------------------------------



// under light - no shadows
#declare light_under =
light_source {
    <0,0,0> 
    #declare light_color = color red .015 green .02 blue .01 ;                      
    light_color * 50                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <0,-200, -20>   
    shadowless
}   
#if (lights_on) light_under #end
                           
                           
// top back light 
#declare light_top_back =
light_source {
    <0,0,0> 
    #declare light_color = color red .025 green .02 blue .03 ;                      
    light_color * 35                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,350>   
}   
#if (lights_on) light_top_back #end

         
#declare light_brain =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .02 blue .01 ;                      
    light_color * 300                  
    area_light
    <20, 0, 0> <0, 0, 20>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 15
    fade_power 2     
    translate <-20,-15,-15>   
    shadowless
}   
#if (lights_on) light_brain #end







#declare light_weapon_top =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .07 blue .05 ;                      
    light_color * 100                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 5
    fade_power 2     
    translate <-40, 33, -55>   
    //shadowless
}   
#if (lights_on) light_weapon_top #end




#declare light_weapon_bottom =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .07 blue .05 ;                      
    light_color * 100                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 10
    fade_power 2     
    translate <-20, -30, -120>   
    shadowless
}   
#if (lights_on) light_weapon_bottom #end



#declare light_towers_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .04 green .02 blue .01 ;                      
    light_color * 2000                  
    area_light
    <20, 0, 0> <0, 0, 20>         
    8, 8                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 500
    fade_power 2     
    translate <-1000,-2000,5000>   
    shadowless
}   
#if (lights_on) light_towers_A #end




// -----------------------------------------------------------------------------------------
//                      S K Y  D O M E
//------------------------------------------------------------------------------------------ 
background { rgb <0.52, 0.5, 0.5> * 1 } 
 
#macro bg_sphere (sc, pos, rot, img) 
object {
    sphere  
        { 0 1 
        hollow
        pigment{
            image_map{ 
                //hdr img
                jpeg img          
                map_type 1 
                interpolate 4 
                }
      }        
      finish { 
        ambient  1.0 
        diffuse  1 
        emission 1
        }
      scale sc  
      translate pos
      rotate <0, rot, 0>  
      } 
}  
#end

#declare img = "background_4k.jpg"
// bg_sphere (scale, position, rotation, image) 
object { bg_sphere (<8000,8000,8000>, <0,10,0>, 320, img) scale <-1,1,1> }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <0,-50,-500> 
        look_at <0,-5,0>
    } 

#declare cam_top =
    camera {
        up <0, 1, 0>  
        angle 1.5    
        location <0,5000,-10> 
        look_at <0,0,-9.5>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 10    
        location <-1000,200,0> 
        look_at <0,50,0>
    } 

#declare cam_A =
    camera {
        up <0, 1, 0>  
        angle 50    
        location <200,-40,-50> 
        look_at <0,-40,-50>
    } 
    
#declare cam_B =
    camera {
        up <0, 1, 0>  
        angle 45    
        location <-30,100,-400> 
        look_at <20,-1,0>
    } 


#declare cam_C =
    camera {
        up <0, 1, 0>  
        angle 60    
        location <5,30,-140> 
        look_at <-5,15,0>
    } 

#declare cam_tower =
    camera {
        up <0, 1, 0>  
        angle 100    
        location <0,400,-800> 
        look_at <0,100,0>
    }

//cam_top         
//camera {cam_front}    //hide sky & stage
//camera {cam_side}     //hide sky & stage
//camera {cam_elev}     //hide sky & stage
camera {cam_B}